
markup.push({

// MARK: denoise block

DenoiseBlock:
{
	"+": "BlockTemplate",
	geNodeClass: "GEDenoiseNode",
    h4PresetsId: "DenoisePresets",
	gxPopoverInfo: "DenoisePopover",
	gxLibraryDescription: "Remove noise from audio",
	gxLibraryIcon: "library.effect.generic",
	gxTitle: "Denoise",
	axTitle: "De Noise",
	gxChildViews:
	{
        statusLight: {
            "+": "StatusLightView",
            gxDisableOnKey: "node.darkStatusLight",
            gxFrameRect: "30,46,11,11",
        },
		learnLabel: {
			"+": "LabelView.left.foreColorTheme1.top.size12",
			gxFrameRect: "47,44,60,20",
			gxValueKey: "node.learnButtonLabel",
			axIsIgnored: false,
			axTitle: "Status",
		},
		sampleReadout: {
			"+": "LabelView.centerx.wrap.foreColorTheme1.top.size10",
			gxFrameRect: "10,63,100,15",
			gxValueKey: "node.sampleDuration",
			gxAnimateOnKey: "node.learnNoiseButton",
			gxFormatter: {
				nsClass: "GXScaledFormatter",
				offset: 0, scale: 1,
				format: "%.1fs noise learned",
				zeroFormat: "No noise learned"
			},
		},
		learn: {
			"+": "BlockButton",
			gxValueKey: "node.learnNoiseButton",
			gxDisplayValueKey: "node.learnButtonTitle",
			gxShowOnKey: "node.blockButtonShown",
			gxFrameRect: "16,85,88,18",
            gxButtonType: "toggle",
        }
	},
},

// MARK: denoise popover

DenoisePopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Denoise",
	axTitle: "De Noise",
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxLayout: [ "H:|-12-[self(350)]-12-|",	// sets popover width
				"V:|-12-[self]-12-|",
				"V:|-39-[group]-(-1)-[group2]-10-[presetsGroup]"
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup("RADenoisePresetsV2"),
		group: {
			"+": "GroupView",
			gxLayout: [
				"H:|-0-[self]-0-|",
				"H:|-14-[statusLight(12)]-11-[learnLabel]-12-[learn(120)]-12-|",
				"H:[statusLight]-11-[sampleReadout]-12-[learn]",

				"V:|-24-[statusLight(12)]",
				"V:|-13-[learnLabel(18)]-(1)-[sampleReadout]",
				"V:|-16-[learn(25)]-16-|",
				
			],
			gxChildViews: {
				learn: {
					"+": "ButtonView",
					//gxTitle: "Learn Noise",
					gxValueKey: "node.learnNoiseButton",
					gxDisplayValueKey: "node.learnButtonTitle",
                    gxButtonType: "toggle",
                },
				statusLight: {
					"+": "StatusLightView",
					gxDisableOnKey: "node.darkStatusLight",
				},
				learnLabel: {
					"+": "LabelView.left.top.size14",
					gxValueKey: "node.learnButtonLabel",
					axIsIgnored: false,
					axTitle: "Status",
				},
				sampleReadout: {
					"+": "LabelView.left.dark.top.size11",
					gxValueKey: "node.sampleDuration",
					gxAnimateOnKey: "node.learnNoiseButton",
					gxFormatter: { nsClass: "GXScaledFormatter", offset: 0, scale: 1, format: "%.1fs of noise learned", zeroFormat: "No noise learned" },
					axIsIgnored: false,
					axTitle: "Sample details",
				},
			},
		},
		group2: {
			"+": "GroupView",
			gxLayout: [
				"H:|-0-[self]-0-|",
				"H:|-12-[reduction]-12-|",
				"H:|-12-[remainingNoiseFloor]-12-|",

				"V:|-30-[reduction]-22-[remainingNoiseFloor]-12-[infoText(44)]-16-|",

				"V:[reductionLabel]-(-1)-[reduction]&alignLeft",
				"V:[reductionReadout]-(-1)-[reduction]&alignRight",

				"V:[remainingNoiseFloorLabel]-(-1)-[remainingNoiseFloor]&alignLeft",
				"V:[remainingNoiseFloorReadout]-(-1)-[remainingNoiseFloor]&alignRight",

				"H:|-12-[infoIcon(16)]-8-[infoText]-11-|",
				"V:[remainingNoiseFloor]-14-[infoIcon]",
			],
			gxChildViews: {
				reductionLabel: labelView("Noise Reduction"),
				reduction: {
					"+": "SliderView",
					gxValueKey: "node.reduction_dB",
					gxRangeMin: 3,
					gxRangeMax: 40,
					gxDefaultValue: 6,
					gxKeystrokeStepSize: 0.1,
					axTitle: "Noise Reduction",
					axFormatter: "DBFormatter",
				},
				reductionReadout: {
					"+": "ReadoutView",
					gxValueKey: "node.reduction_dB",
					gxClickValue: 6,
					gxFormatter: "DBFormatter",
				},
				remainingNoiseFloorLabel: labelView("Remaining Noise Floor"),
				remainingNoiseFloor: {
					"+": "SliderView",
					gxValueKey: "node.remainingNoiseFloor_dB",
					gxRangeMin: -60,
					gxRangeMax: -20,
					gxDefaultValue: -40,
					gxKeystrokeStepSize: 0.1,
					axTitle: "Remaining Noise Floor",
					axFormatter: "DBFormatter",
				},
				remainingNoiseFloorReadout: {
					"+": "ReadoutView",
					gxValueKey: "node.remainingNoiseFloor_dB",
					gxClickValue: -40,
					gxFormatter: "DBFormatter",
				},
				infoIcon: { "+": "InfoIcon" },
				infoText: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "Click “Learn Noise” to train the filter with the noise to be removed. 3 seconds of sound will be sampled. Click “Stop Learning” to end training earlier.",
				},
			}
		}
	}
},

    
})
